package joyfill.editors.components

import joyfill.editors.barcode.BarcodeEditor
import joyfill.editors.block.BlockEditor
import joyfill.editors.date.DateEditor
import joyfill.editors.dropdown.DropdownEditor
import joyfill.editors.file.FileEditor
import joyfill.editors.image.ImageEditor
import joyfill.editors.multi_select.MultiSelectEditor
import joyfill.editors.number.NumberEditor
import joyfill.editors.signature.SignatureEditor
import joyfill.editors.text.TextEditor
import joyfill.editors.text_area.TextAreaEditor
import joyfill.table.Finder

interface ComponentEditorFinder : Finder<ComponentEditor> {
    override fun text(key: String?): TextEditor?
    override fun block(key: String?): BlockEditor?
    override fun textArea(key: String?): TextAreaEditor?
    override fun barcode(key: String?): BarcodeEditor?
    override fun dropdown(key: String?): DropdownEditor?
    override fun number(key: String?): NumberEditor?
    override fun file(key: String?): FileEditor?
    override fun signature(key: String?): SignatureEditor?
    override fun multiSelect(key: String?): MultiSelectEditor?
    override fun date(key: String?): DateEditor?
    override fun image(key: String?): ImageEditor?
}