package joyfill.editors.collection.internal

import joyfill.editors.collection.entries.LazyEntry

internal fun CollectionEditorImpl.collapse(entry: LazyEntry) {
    val list = state.value.entries.toMutableList()
    val index = list.indexOf(entry)
    if (index >= 0) {
        list.removeAll { it.id.contains(entry.id) }
        list.add(index.coerceAtMost(list.size), entry.copy(expanded = false))
        state.value = state.value.copy(entries = list)
        rebuildEntryIndexes()
    }
} 