package joyfill.editors.collection.internal

import joyfill.editors.collection.entries.LazyEntry
import joyfill.editors.collection.entries.RowEntry
import joyfill.editors.collection.entries.TableEntry

internal fun CollectionEditorImpl.updateRowValidity(rowEntry: RowEntry) {
    val lazyEntries = state.value.entries.toMutableList()
    val indexOfRow = lazyEntries.indexOf(rowEntry)
    lazyEntries.remove(rowEntry)
    lazyEntries.add(indexOfRow, rowEntry.copy(isValid = rowEntry.manager.isValid.value))
    state.value = state.value.copy(entries = lazyEntries)
    rebuildEntryIndexes()
}


internal fun CollectionEditorImpl.setHidden(rowEntry: RowEntry) {
    if (rowEntry.manager.state.value.visibility.isHidden() == rowEntry.hidden) return
    val lazyEntries = state.value.entries.toMutableList()
    val indexOfRow = lazyEntries.indexOf(rowEntry)
    lazyEntries.remove(rowEntry)
    lazyEntries.add(
        indexOfRow, rowEntry.copy(
            hidden = rowEntry.manager.state.value.visibility.isHidden(),
        )
    )
    state.value = state.value.copy(entries = lazyEntries)
    rebuildEntryIndexes()
}

internal fun CollectionEditorImpl.setHidden(tableEntry: TableEntry){
    val lazyEntries = state.value.entries.toMutableList()
    val indexOfRow = lazyEntries.indexOf(tableEntry)
    lazyEntries.remove(tableEntry)
    lazyEntries.add(
        indexOfRow, tableEntry.copy(
            hidden = tableEntry.table.state.value.visibility.isHidden()
        )
    )
    state.value = state.value.copy(entries = lazyEntries)
    rebuildEntryIndexes()
}

internal fun CollectionEditorImpl.updateEntries(
    rowEntry: RowEntry,
    tableEntriesToAdd: List<TableEntry>,
) {
    val lazyEntries = state.value.entries.toMutableList()
    val indexOfRow = lazyEntries.indexOf(rowEntry)

    //Remove the row entry and add it back as expanded
    lazyEntries.remove(rowEntry)
    lazyEntries.add(indexOfRow, rowEntry.copy(expanded = true))

    // Add the new table entries after the row entry
    lazyEntries.addAll(indexOfRow + 1, tableEntriesToAdd)

    //Update the state with the new entries
    state.value = state.value.copy(entries = lazyEntries)
    rebuildEntryIndexes()

    if (tableEntriesToAdd.isNotEmpty()) {
        val allExpandedChildren = mutableListOf<LazyEntry>()
        val childIndices = mutableListOf<Int>()

        tableEntriesToAdd.forEach { tableEntry ->
            val childIndex = state.value.entries.indexOf(tableEntry)
            if (childIndex >= 0) {
                childIndices.add(childIndex)
                allExpandedChildren.addAll(tableEntry.expanded())
            }
        }
        if (allExpandedChildren.isNotEmpty()) {
            val updatedList = state.value.entries.toMutableList()
            tableEntriesToAdd.forEach { tableEntry ->
                updatedList.removeAll { it.id.contains(tableEntry.id) }
            }

            if (childIndices.isNotEmpty()) {
                val firstChildIndex = childIndices.minOrNull() ?: (indexOfRow + 1)
                updatedList.addAll(firstChildIndex, allExpandedChildren)
            }

            state.value = state.value.copy(entries = updatedList)
            rebuildEntryIndexes()
        }
    }
}