package joyfill.editors.collection.entries

import joyfill.editors.collection.TableEditor
import joyfill.table.Row

data class TableEntry(
    override val level: Int,
    override val table: TableEditor,
    override val expanded: Boolean,
    override val hidden: Boolean,
    val parent: Row? = null,
    override val isValid: Boolean
) : LazyEntry {
    override val id = table.id

    override val name: String = "TableEntry"

    val required = table.component.required

    override fun copy(expanded: Boolean) = TableEntry(level, table, expanded, hidden, parent, isValid)
}