package joyfill.editors.collection

import cinematic.Live
import joyfill.editors.table.ColumnFilter
import joyfill.editors.table.ColumnSorter
import joyfill.editors.table.ColumnTransformer
import joyfill.editors.table.Filter
import joyfill.editors.table.SortingOption
import joyfill.editors.table.TableFilterState
import joyfill.table.Column
import joyfill.table.TableSchema

interface TableFilter: Filter {
    val schema: TableSchema

    val state: Live<TableFilterState>

    fun addFilter(): ColumnFilter

    fun addSorter(): ColumnSorter?

    fun ColumnTransformer.select(column: Column?):  ColumnTransformer?

    fun ColumnFilter.updateFilterValue(newValue: Any?):  ColumnFilter

    fun updateSorterValue(sort: SortingOption): ColumnSorter?
}