package joyfill.editors.collection

import cinematic.Live
import joyfill.collection.TableSchemas
import joyfill.editors.table.Filter
import joyfill.table.TableSchema

interface FilterCollection : Filter {

    val current: Live<TableFilter?>

    val isActive: Boolean

    val schemas: TableSchemas

    //Selects a schema to apply filters and sorts to
    fun select(editor: TableEditor): TableFilter

    fun select(schema: TableSchema): TableFilter

    //Adds an empty filter to the current selected TableSchema
    fun addFilter(): TableFilter?

    //Adds an empty sorter to the current selected TableSchema
    fun addSorter(): TableFilter?
}