package joyfill.editors.chart.internal

import cinematic.mutableLiveOf
import joyfill.chart.Axis
import joyfill.editors.chart.AxisEditor

internal class AxisEditorImpl(override val axis: Axis) : AxisEditor {

    override val state by  lazy {
        mutableLiveOf(
            AxisEditorStateImpl(
                label = axis.label,
                min = axis.min,
                max = axis.max
            )
        )
    }

    override fun label(value: String) {
        state.value = state.value.copy(label = value)
        axis.label = value
    }

    override fun min(value: Double?) {
        val v = value ?: return
        axis.min = v
        state.value = state.value.copy(min = v)
    }

    override fun max(value: Double?) {
        val v = value ?: return
        axis.max = v
        state.value = state.value.copy(max = v)
    }
}