package joyfill.collections

import cinematic.Live
import joyfill.Page
import joyfill.editors.page.PageEditor

interface PageCollection {

    val state: Live<PageCollectionState>

    fun raw() : List<Page>

    fun all(): List<PageEditor>
    /**
     * @param key "A Key can be either an id of the page, or the name of the page"
     * @throws IllegalArgumentException if the key is not found
     */
    fun find(key: String?): PageEditor?
    fun at(index: Int): PageEditor?

    fun setHidden(key: String?, value: Boolean): Page?

    fun navigate(page: String?): Page?
    fun navigate(page: Page?): Page?

    fun duplicate(page: String?, newName: String): Page?
    fun duplicate(page: Page?, newName: String): Page?
}