package joyfill2.tools.validation

import joyfill2.table.Column
import joyfill2.table.Row

sealed interface RowValidity : Validity {
    val row: Row
    val cells: Map<Column, ComponentValidity>
}

data class RowValid(
    override val row: Row,
    override val cells: Map<Column, ComponentValid>
) : RowValidity, Valid {
    override fun toString() = cells.entries.joinToString(prefix = "[", separator = ",", postfix = "]") { (column, validity) ->
        "${column.title} = ${validity.component.value}"
    }
}

data class RowInvalid(
    override val row: Row,
    override val cells: Map<Column, ComponentValidity>,
    val valid: Map<Column, ComponentValid>,
    val invalid: Map<Column, ComponentInvalid>
) : RowValidity, Invalid {
    override fun toString() = cells.entries.joinToString(prefix = "{", separator = ",", postfix = "}") { (column, validity) ->
        buildString {
            append(column.title)
            append(" = ")
            if (validity is Invalid) append("{")
            append(validity.component.value)
            if (validity is Invalid) append("}")
        }
    }
}

