package joyfill2.tools.validation

import joyfill2.Field

sealed interface FieldValidity : Validity {
    val field: Field
    val messages: List<String>
}

data class FieldValid(
    override val field: Field,
    override val messages: List<String>
) : FieldValidity, Valid

data class FieldInvalid(
    override val field: Field,
    override val messages: List<String>
) : FieldValidity, Invalid