package joyfill2.tools.validation

import joyfill2.components.Component

sealed interface ComponentValidity : Validity {
    val component: Component
    val messages: List<String>
}

data class ComponentValid(
    override val component: Component,
    override val messages: List<String>
) : ComponentValidity, Valid

data class ComponentInvalid(
    override val component: Component,
    override val messages: List<String>
) : ComponentValidity, Invalid