package joyfill2.events.internal

import joyfill2.events.RowUpdateChange
import joyfill2.table.Column
import joyfill2.table.Row
import joyfill2.table.toTableRow


internal class RowUpdateChangeImpl(
    columns: List<Column>,
    private val wrapped: Map<String, Any?>
) :
    RowUpdateChange, RowChangeImpl(wrapped) {

    override val rowId: String by lazy { wrapped[RowUpdateChange::rowId.name] as String }

    override val row: Row by lazy {
        (wrapped[RowUpdateChange::row.name] as Map<String, Any?>).toMutableMap().toTableRow(columns)
    }
}