package joyfill2.events.internal

import joyfill2.events.RowCreateChange
import joyfill2.table.Column
import joyfill2.table.Row
import joyfill2.table.toTableRow

internal class RowCreateChangeImpl(
    columns: List<Column>,
    private val wrapped: Map<String, Any?>
) : RowCreateChange, RowChangeImpl(wrapped) {

    override val targetRowIndex: Int by lazy {
        wrapped[RowCreateChange::targetRowIndex.name] as Int
    }

    override val row: Row by lazy {
        (wrapped[RowCreateChange::row.name] as Map<String, Any?>).toMutableMap().toTableRow(columns)
    }
}