package joyfill2.events.internal


import joyfill2.Document
import joyfill2.events.ChangeEvent
import joyfill2.events.ChangeLog
import joyfill2.events.toChangeLog
import joyfill2.internal.AbstractMappable
import joyfill2.table.Column
import joyfill2.toDocument
import joyfill2.utils.JsonList
import joyfill2.utils.toJsonObject
import kotlinx.serialization.encodeToString
import kotlinx.serialization.json.Json
import kotlinx.serialization.json.JsonObject

internal class ChangeEventImpl(
    private val columns: List<Column>,
    wrapped: MutableMap<String, Any?>
) : AbstractMappable(wrapped), ChangeEvent {

    override val changelogs: List<ChangeLog> = JsonList(wrapped[ChangeEvent::changelogs.name]) { it.toChangeLog(columns) }

    override val document: Document = (wrapped[ChangeEvent::document.name] as MutableMap<String, Any?>).toDocument()

    override fun toMap() = wrapped

    override fun toJsonString(): String = Json.encodeToString(toJsonObject())

    override fun toJsonObject(): JsonObject = wrapped.toJsonObject()
}