package joyfill2.events

import joyfill2.events.internal.ChangeEventImpl
import joyfill2.events.internal.ChangeLogImpl
import joyfill2.events.internal.FieldUpdateChangeImpl
import joyfill2.events.internal.RowCreateChangeImpl
import joyfill2.events.internal.RowDeleteChangeImpl
import joyfill2.events.internal.RowMoveChangeImpl
import joyfill2.events.internal.RowUpdateChangeImpl
import joyfill2.events.internal.UnknownChangeImpl
import joyfill2.table.Column

fun MutableMap<String, Any?>.toChangeLog(columns: List<Column>): ChangeLog = ChangeLogImpl(columns, this)

fun MutableMap<String, Any?>.toChangeEvent(columns: List<Column>): ChangeEvent = ChangeEventImpl(columns, this)

fun MutableMap<String, Any?>.toFieldChange(): FieldUpdateChange = FieldUpdateChangeImpl(this)

fun MutableMap<String, Any?>.toRowCreateChange(columns: List<Column>): RowCreateChange = RowCreateChangeImpl(columns,this)

fun MutableMap<String, Any?>.toRowMoveChange(): RowMoveChange = RowMoveChangeImpl(this)

fun MutableMap<String, Any?>.toRowDeleteChange(): RowDeleteChange = RowDeleteChangeImpl(this)

fun MutableMap<String, Any?>.toRowUpdateChange(columns: List<Column>): RowUpdateChange = RowUpdateChangeImpl(columns,this)

fun MutableMap<String, Any?>.toUnknownChange(): Change = UnknownChangeImpl(this)