@file:Suppress("DELEGATED_MEMBER_HIDES_SUPERTYPE_OVERRIDE")

package joyfill2.editors.unknown

import cinematic.mutableLiveOf
import joyfill2.Document
import joyfill2.collections.PageCollection
import joyfill2.components.Component
import joyfill2.components.ComponentSchema
import joyfill2.editors.components.ComponentEditor
import joyfill2.editors.components.internal.AbstractComponentEditor
import joyfill2.events.ChangeEvent
import joyfill2.events.EventDispatcher
import joyfill2.tools.validation.ComponentValid
import joyfill2.tools.validation.ComponentValidityState

internal class UnknownEditor(
    component: Component,
    document: Document,
    pages: PageCollection?,
    onChange: ((ChangeEvent) -> Unit)?,
    identifier: String,
    fieldId: String = component.id,
    dispatcher: EventDispatcher?,
) : AbstractComponentEditor(document, pages,component, {}, onChange, identifier, fieldId, dispatcher),
    ComponentEditor,
    ComponentSchema by component {
    override val state by lazy { mutableLiveOf(State(component)) }

    data class State(private val component: Component) : ComponentValidityState {
        override val validity = ComponentValid(component, emptyList())
    }

    override fun changeHiddenTo(value: Boolean) {
        hidden = value
    }
}
