package joyfill2.editors.text

import joyfill2.Document
import joyfill2.collections.PageCollection
import joyfill2.editors.components.ComponentEditor
import joyfill2.editors.components.internal.AbstractCompStringEditorImpl
import joyfill2.events.ChangeEvent
import joyfill2.events.EventDispatcher
import joyfill2.text.TextComponent
import joyfill2.tools.validation.ComponentValidity
import wisdom.ResolutionResource
import wisdom.ast.Library

internal class TextEditorImpl(
    component: TextComponent,
    dependents: List<ComponentEditor>,
    resolver: ResolutionResource?,
    library: Library?,
    document: Document,
    pages: PageCollection?,
    onChange: ((ChangeEvent) -> Unit)?,
    onValidate: (ComponentValidity) -> Unit,
    identifier: String,
    fieldId: String = component.id,
    dispatcher: EventDispatcher?,
) : AbstractCompStringEditorImpl<TextComponent>(
    component = component,
    document = document,
    pages = pages,
    dependents = dependents,
    resolver = resolver,
    library = library,
    onChange = onChange,
    onValidate = onValidate,
    identifier = identifier,
    fieldId = fieldId,
    dispatcher = dispatcher,
), TextEditor