package joyfill2.editors.table.internal

import joyfill2.editors.table.RowManager
import joyfill2.editors.table.Selection
import joyfill2.editors.table.TableEditorState
import joyfill2.tools.validation.TableValidity
import joyfill2.tools.visibility.Visibility

data class TableEditorStateImpl(
    override val validity: TableValidity,
    override val rows: List<RowManager>,
    override val selected: List<RowManager>,
    override val form: RowManager?,
    override val hidden: Boolean,
    override val visibility: Visibility,
) : TableEditorState {

    fun selection(): Selection = when {
        rows.isEmpty() -> Selection.None
        selected.size == rows.size -> Selection.All
        selected.isEmpty() -> Selection.None
        selected.isNotEmpty() -> Selection.Some(selected)
        else -> Selection.None
    }
}