package joyfill2.editors.table.internal

import joyfill2.editors.table.RowManager
import joyfill2.events.ChangeLog
import joyfill2.events.FieldUpdateChange
import joyfill2.events.RowCreateChange
import joyfill2.events.RowDeleteChange
import joyfill2.events.RowUpdateChange
import joyfill2.table.Column
import joyfill2.table.Row
import joyfill2.table.TableSchema

internal class TableChangeLogBuilder(
    private val columns: List<Column>,
) {
    fun buildRowCreateChangeValue(rowManager: RowManager, index: Int): MutableMap<String, Any?> {
        return mutableMapOf(
            RowCreateChange::targetRowIndex.name to index,
            RowCreateChange::row.name to getChangeLogRow(rowManager.row),
            TableSchema::columns.name to columns,
        )
    }

    fun buildRowMoveChangeValue(row: Row?, index: Int): MutableMap<String, Any?> {
        return mutableMapOf(
            RowCreateChange::targetRowIndex.name to index,
            RowDeleteChange::rowId.name to row?.id
        )
    }

    fun buildRowDeleteChangeValue(rowManager: RowManager): MutableMap<String, Any?> {
        return mutableMapOf(
            RowDeleteChange::rowId.name to rowManager.row.id
        )
    }

    fun buildRowUpdateChangeValue(row: Row, changeLog: ChangeLog): MutableMap<String, Any?> {
        val value = (changeLog.toMap()[ChangeLog::change.name] as? Map<*, *>)?.get(FieldUpdateChange::value.name)
        val id = changeLog.fieldId
        val singleCellMap = mutableMapOf(id to value)
        val newRowMap = row.toMap().toMutableMap()
        with(newRowMap) {
            this[Row::cells.name] = singleCellMap
            remove(Row::deleted.name)
            remove(Row::children.name)
        }

        return mutableMapOf(
            RowUpdateChange::rowId.name to row.id,
            RowUpdateChange::row.name to newRowMap,
            TableSchema::columns.name to columns,
        )
    }

    private fun getChangeLogRow(row: Row): MutableMap<String, Any?> {
        val wrapped = row.toMap()
        return wrapped.apply {
            remove(Row::deleted.name)
            remove(Row::children.name)
        }
    }
} 
