package joyfill2.editors.table.internal

import joyfill2.Document
import joyfill2.IdentityGenerator
import joyfill2.editors.table.RowManager
import joyfill2.events.ChangeEvent
import joyfill2.table.Column
import joyfill2.table.Row

internal class RowManagerImpl(
    override val row: Row,
    columns: List<Column>,
    document: Document,
    identity: IdentityGenerator,
    onChange: ((ChangeEvent) -> Unit)?,
    override val next: () -> RowManager?,
    override val prev: () -> RowManager?,
    fieldId: String,
    identifier: String,
) : AbstractRowManager(row, document, columns, identity, onChange, {}, fieldId, identifier) {
    override val id: String = row.id
}