package joyfill2.editors.table.internal

import joyfill2.barcode.BarcodeColumn
import joyfill2.block.BlockColumn
import joyfill2.date.DateColumn
import joyfill2.dropdown.DropdownColumn
import joyfill2.editors.table.RowManager
import joyfill2.image.ImageColumn
import joyfill2.multi_select.MultiSelectColumn
import joyfill2.number.NumberColumn
import joyfill2.signature.SignatureColumn
import joyfill2.table.Column
import joyfill2.text.TextColumn

internal fun RowManager.copyInto(other: RowManager, column: Column) {
    when (column) {
        is TextColumn -> {
            val value = text(column.id)?.state?.value?.data
            if (value.isNullOrBlank()) return
            other.text(column.id)?.value(value) ?: return
        }

        is DateColumn -> {
            val value = date(column.id)?.state?.value?.data ?: return
            if (value == 0L) return
            other.date(column.id)?.value(value)
        }

        is BlockColumn -> {
            val value = block(column.id)?.state?.value?.data
            if (value.isNullOrBlank()) return
            other.block(column.id)?.value(value)
        }

        is NumberColumn -> {
            val value = number(column.id)?.state?.value?.data ?: return
            if (value.isNaN() || value == 0.0) return
            other.number(column.id)?.value(value)
        }

        is DropdownColumn -> {
            val selected = dropdown(column.id)?.state?.value?.data ?: return
            val cell = other.dropdown(column.id) ?: return
            cell.select(selected)
        }

        is MultiSelectColumn -> {
            val selected = multiSelect(column.id)?.state?.value?.data ?: return
            val cell = other.multiSelect(column.id) ?: return
            cell.set(selected)
        }

        is ImageColumn -> {
            val images = image(column.id)?.state?.value?.data ?: return
            other.image(column.id)?.set(images) ?: return
        }

        is BarcodeColumn -> {
            val value = barcode(column.id)?.state?.value?.data
            if (value.isNullOrBlank()) return
            other.barcode(column.id)?.value(value) ?: return
        }

        is SignatureColumn -> {
            val value = signature(column.id)?.state?.value?.data
            if (value.isNullOrBlank()) return
            other.signature(column.id)?.value(value) ?: return
        }

        else -> {}
    }
}
