package joyfill2.editors.table.internal

import joyfill2.Document
import joyfill2.IdentityGenerator
import joyfill2.barcode.BarcodeCell
import joyfill2.block.BlockCell
import joyfill2.date.DateCell
import joyfill2.dropdown.DropdownCell
import joyfill2.editors.barcode.BarcodeEditorImpl
import joyfill2.editors.block.BlockEditorImpl
import joyfill2.editors.components.ComponentEditor
import joyfill2.editors.date.internal.DateEditorImpl
import joyfill2.editors.dropdown.internal.DropdownEditorImpl
import joyfill2.editors.file.internal.FileEditorImpl
import joyfill2.editors.image.ImageEditorImpl
import joyfill2.editors.multi_select.internal.MultiSelectEditorImpl
import joyfill2.editors.number.internal.NumberEditorImpl
import joyfill2.editors.signature.SignatureEditorImpl
import joyfill2.editors.text.TextEditorImpl
import joyfill2.editors.text_area.TextAreaEditorImpl
import joyfill2.editors.unknown.UnknownEditor
import joyfill2.events.ChangeEvent
import joyfill2.file.FileCell
import joyfill2.image.ImageCell
import joyfill2.multi_select.MultiSelectCell
import joyfill2.number.NumberCell
import joyfill2.signature.SignatureCell
import joyfill2.table.Cell
import joyfill2.table.Column
import joyfill2.text.TextCell
import joyfill2.text_area.TextAreaCell
import joyfill2.tools.validation.ComponentValidity

internal fun Cell.toEditor(
    cache: MutableMap<String, ComponentEditor>,
    validation: MutableMap<Column, ComponentValidity>,
    document: Document,
    identity: IdentityGenerator,
    onChange: ((ChangeEvent) -> Unit)?,
    fieldId: String,
    identifier: String,
    onCellValidated: (Cell, ComponentValidity) -> Unit,
): ComponentEditor = cache.getOrPut(id) {
    val editor = when (this) {
        is TextCell -> TextEditorImpl(
            component = this,
            document = document,
            pages = null,
            onChange = onChange,
            onValidate = { validity -> onCellValidated(this, validity) },
            fieldId = fieldId,
            identifier = identifier,
            dependents = emptyList(),
            resolver = null,
            library = null,
            dispatcher = null
        )

        is BlockCell -> BlockEditorImpl(
            component = this,
            document = document,
            onChange = onChange,
            onValidate = { onCellValidated(this, it) },
            fieldId = fieldId,
            identifier = identifier,
            dependents = emptyList(),
            resolver = null,
            library = null,
            pages = null,
            dispatcher = null
        )

        is TextAreaCell -> TextAreaEditorImpl(
            component = this,
            document = document,
            onChange = onChange,
            onValidate = { validity -> onCellValidated(this, validity) },
            fieldId = fieldId,
            identifier = identifier,
            dependents = emptyList(),
            resolver = null,
            library = null,
            pages = null,
            dispatcher = null
        )

        is SignatureCell -> SignatureEditorImpl(
            component = this,
            document = document,
            onChange = onChange,
            onValidate = { validity -> onCellValidated(this, validity) },
            fieldId = fieldId,
            identifier = identifier,
            dependents = emptyList(),
            resolver = null,
            library = null,
            pages = null,
            dispatcher = null
        )

        is DropdownCell -> DropdownEditorImpl(
            component = this,
            options = column.options,
            document = document,
            onChange = onChange,
            onValidate = { validity -> onCellValidated(this, validity) },
            fieldId = fieldId,
            identifier = identifier,
            pages = null,
            dispatcher = null
        )

        is NumberCell -> NumberEditorImpl(
            component = this,
            document = document,
            onChange = onChange,
            onValidate = { validity -> onCellValidated(this, validity) },
            fieldId = fieldId,
            identifier = identifier,
            dependents = emptyList(),
            resolver = null,
            library = null,
            pages = null,
            dispatcher = null
        )

        is DateCell -> DateEditorImpl(
            component = this,
            format = column.format,
            document = document,
            onChange = onChange,
            onValidate = { validity -> onCellValidated(this, validity) },
            fieldId = fieldId,
            identifier = identifier,
            pages = null,
            dispatcher = null
        )

        is BarcodeCell -> BarcodeEditorImpl(
            component = this,
            document = document,
            onChange = onChange,
            onValidate = { validity -> onCellValidated(this, validity) },
            fieldId = fieldId,
            identifier = identifier,
            dependents = emptyList(),
            resolver = null,
            library = null,
            pages = null,
            dispatcher = null
        )

        is ImageCell -> ImageEditorImpl(
            component = this,
            identity = identity,
            document = document,
            onChange = onChange,
            onValidate = { validity -> onCellValidated(this, validity) },
            fieldId = fieldId,
            identifier = identifier,
            pages = null,
            dispatcher = null
        )

        is FileCell -> FileEditorImpl(
            component = this,
            identity = identity,
            document = document,
            onChange = onChange,
            onValidate = { validity -> onCellValidated(this, validity) },
            fieldId = fieldId,
            identifier = identifier,
            pages = null,
            dispatcher = null
        )

        is MultiSelectCell -> MultiSelectEditorImpl(
            component = this,
            options = column.options,
            document = document,
            onChange = onChange,
            onValidate = { validity -> onCellValidated(this, validity) },
            fieldId = fieldId,
            identifier = identifier,
            pages = null,
            dispatcher = null
        )

        else -> UnknownEditor(
            component = this,
            document = document,
            onChange = null,
            fieldId = fieldId,
            identifier = identifier,
            pages = null,
            dispatcher = null
        )
    }
    validation[this.column] = editor.state.value.validity
    editor
}