package joyfill2.editors.table.internal

import joyfill2.barcode.BarcodeColumn
import joyfill2.block.BlockColumn
import joyfill2.date.DateColumn
import joyfill2.dropdown.DropdownColumn
import joyfill2.editors.table.ColumnFinder
import joyfill2.file.FileColumn
import joyfill2.image.ImageColumn
import joyfill2.multi_select.MultiSelectColumn
import joyfill2.number.NumberColumn
import joyfill2.signature.SignatureColumn
import joyfill2.table.Column
import joyfill2.table.TableSchema
import joyfill2.text.TextColumn
import joyfill2.text_area.TextAreaColumn

internal abstract class AbstractColumnFinder(
    private val table: TableSchema
) : ColumnFinder {

    override fun all(): List<Column> = table.columns

    private fun Column.keys() = listOf(id, title).map { it.lowercase() }

    private fun look(key: String): Column? = table.columns.find { key.lowercase() in it.keys() }

    override fun find(key: String?): Column? = key?.let { look(key) }

    override fun text(key: String?): TextColumn? = find(key) as? TextColumn

    override fun signature(key: String?): SignatureColumn? = find(key) as? SignatureColumn

    override fun block(key: String?): BlockColumn? = find(key) as? BlockColumn

    override fun barcode(key: String?): BarcodeColumn? = find(key) as? BarcodeColumn

    override fun textArea(key: String?): TextAreaColumn? = find(key) as? TextAreaColumn

    override fun multiSelect(key: String?): MultiSelectColumn? = find(key) as? MultiSelectColumn

    override fun number(key: String?): NumberColumn? = find(key) as? NumberColumn

    override fun date(key: String?): DateColumn? = find(key) as? DateColumn

    override fun dropdown(key: String?): DropdownColumn? = find(key) as? DropdownColumn

    override fun image(key: String?): ImageColumn? = find(key) as? ImageColumn

    override fun file(key: String?): FileColumn? = find(key) as? FileColumn
}