package joyfill2.editors.table

import joyfill2.barcode.BarcodeColumn
import joyfill2.block.BlockColumn
import joyfill2.date.DateColumn
import joyfill2.dropdown.DropdownColumn
import joyfill2.file.FileColumn
import joyfill2.image.ImageColumn
import joyfill2.multi_select.MultiSelectColumn
import joyfill2.number.NumberColumn
import joyfill2.signature.SignatureColumn
import joyfill2.table.Cells
import joyfill2.table.TableSchema
import joyfill2.table.toCells
import joyfill2.text.TextColumn
import joyfill2.text_area.TextAreaColumn
import joyfill2.utils.Attachment

fun TableSchema.intiCells(empty: Boolean): Cells = columns.toCells(
    columns.flatMap { column ->
        listOf(
            column.id to when (column) {
                is TextColumn -> if (empty) null else column.value
                is TextAreaColumn ->  if (empty) null else column.value
                is BarcodeColumn ->  if (empty) null else column.value
                is NumberColumn -> if (empty) null else column.value
                is DateColumn ->  if (empty) null else column.value
                is DropdownColumn ->  if (empty) null else column.value
                is SignatureColumn ->  if (empty) null else column.value
                is BlockColumn -> if (empty) null else column.value
                is ImageColumn -> if (empty) mutableListOf<Attachment>() else column.value.map { it.toMap() }.toMutableList()
                is FileColumn -> if (empty) mutableListOf<Attachment>() else column.value.map { it.toMap() }.toMutableList()
                is MultiSelectColumn -> if (empty) mutableListOf<String>() else column.value.toMutableList()
                else -> null
            }
        )
    }.toMap().toMutableMap()
)