package joyfill2.editors.table

import joyfill2.table.Row


interface Rows<out M : RowManager> {
    fun all(): List<M>
    fun append(): M
    fun create(empty: Boolean = false): M
    fun find(id: String): M?
    fun delete(keys: List<String>): List<M>
    fun addAfter(id: String): M?
    fun up(id: String, by: Int = 1): RowResult<Row>
    fun down(id: String, by: Int = 1): RowResult<Row>
}