package joyfill2.editors.table

import joyfill2.barcode.BarcodeColumn
import joyfill2.block.BlockColumn
import joyfill2.date.DateColumn
import joyfill2.dropdown.DropdownColumn
import joyfill2.file.FileColumn
import joyfill2.image.ImageColumn
import joyfill2.multi_select.MultiSelectColumn
import joyfill2.number.NumberColumn
import joyfill2.signature.SignatureColumn
import joyfill2.table.Column
import joyfill2.table.Finder
import joyfill2.text.TextColumn
import joyfill2.text_area.TextAreaColumn

interface ColumnFinder : Finder<Column> {
    override fun text(key: String?): TextColumn?
    override fun block(key: String?): BlockColumn?
    override fun textArea(key: String?): TextAreaColumn?
    override fun barcode(key: String?): BarcodeColumn?
    override fun number(key: String?): NumberColumn?
    override fun date(key: String?): DateColumn?
    override fun dropdown(key: String?): DropdownColumn?
    override fun multiSelect(key: String?): MultiSelectColumn?
    override fun image(key: String?): ImageColumn?
    override fun file(key: String?): FileColumn?
    override fun signature(key: String?): SignatureColumn?
}


