package joyfill2.editors.signature

import joyfill2.Document
import joyfill2.collections.PageCollection
import joyfill2.editors.components.ComponentEditor
import joyfill2.editors.components.internal.AbstractCompStringEditorImpl
import joyfill2.events.ChangeEvent
import joyfill2.events.EventDispatcher
import joyfill2.signature.SignatureComponent
import joyfill2.tools.validation.ComponentValidity
import wisdom.ResolutionResource
import wisdom.ast.Library

internal class SignatureEditorImpl(
    component: SignatureComponent,
    dependents: List<ComponentEditor>,
    resolver: ResolutionResource?,
    library: Library?,
    document: Document,
    pages: PageCollection?,
    onChange: ((ChangeEvent) -> Unit)?,
    onValidate: (ComponentValidity) -> Unit,
    identifier: String,
    fieldId: String = component.id,
    dispatcher: EventDispatcher?,
) : AbstractCompStringEditorImpl<SignatureComponent>(
    component = component,
    dependents = dependents,
    resolver = resolver,
    library = library,
    document = document,
    pages = pages,
    onChange = onChange,
    onValidate = onValidate,
    fieldId = fieldId,
    identifier = identifier,
    dispatcher = dispatcher,
), SignatureEditor