package joyfill2.editors.number.internal

import cinematic.mutableLiveOf
import joyfill2.Document
import joyfill2.collections.PageCollection
import joyfill2.editors.components.ComponentEditor
import joyfill2.editors.components.internal.AbstractComponentEditor
import joyfill2.editors.number.NumberEditor
import joyfill2.events.ChangeEvent
import joyfill2.events.EventDispatcher
import joyfill2.number.NumberComponent
import joyfill2.tools.validation.ComponentValidity
import joyfill2.tools.visibility.Visibility
import wisdom.ResolutionResource
import wisdom.ast.Library

internal class NumberEditorImpl(
    override val component: NumberComponent,
    dependents: List<ComponentEditor>,
    resolver: ResolutionResource?,
    library: Library?,
    document: Document,
    pages: PageCollection?,
    onChange: ((ChangeEvent) -> Unit)?,
    onValidate: (ComponentValidity) -> Unit,
    identifier: String,
    fieldId: String = component.id,
    dispatcher: EventDispatcher?,
) : NumberEditor, AbstractComponentEditor(
    document,
    pages,
    component,
    onValidate,
    onChange,
    identifier,
    fieldId,
    dispatcher,
    dependents,
    resolver,
    library
) {

    override val state by lazy {
        mutableLiveOf(
            NumberEditorStateImpl(
                data = component.value,
                visibility = if (component.hidden) Visibility.Hidden else Visibility.Visible,
                validity = validate()
            )
        )
    }

    override fun changeHiddenTo(value: Boolean) {
        hidden = value
        state.value = state.value.copy(
            visibility = if (value) Visibility.Hidden else Visibility.Visible,
        )
    }

    override fun value(v: Double?) {
        component.value = v
        resolveConditions()
        state.value = state.value.copy(
            data = v,
            validity = validate(),
            visibility = if (component.hidden) Visibility.Hidden else Visibility.Visible,
        )
        updateDependentsValues()
        notifyChange(v)
    }

    override fun customCondition(): Boolean {
        return component.value?.isNaN() == true || component.value == null
    }
}