package joyfill2.editors.image

import joyfill2.Document
import joyfill2.IdentityGenerator
import joyfill2.collections.PageCollection
import joyfill2.editors.file.internal.AbstractFileEditorImpl
import joyfill2.events.ChangeEvent
import joyfill2.events.EventDispatcher
import joyfill2.image.ImageComponent
import joyfill2.tools.validation.ComponentValidity

internal class ImageEditorImpl(
    override val component: ImageComponent,
    identity: IdentityGenerator,
    document: Document,
    pages: PageCollection?,
    onChange: ((ChangeEvent) -> Unit)?,
    onValidate: (ComponentValidity) -> Unit,
    identifier: String,
    fieldId: String = component.id,
    dispatcher: EventDispatcher?,
) : AbstractFileEditorImpl<ImageComponent>(
    component = component,
    identity = identity,
    document = document,
    pages = pages,
    onChange = onChange,
    onValidate = onValidate,
    fieldId = fieldId,
    identifier = identifier,
    dispatcher = dispatcher
), ImageEditor