package joyfill2.editors.file.internal

import joyfill2.Document
import joyfill2.IdentityGenerator
import joyfill2.collections.PageCollection
import joyfill2.editors.file.FileEditor
import joyfill2.events.ChangeEvent
import joyfill2.events.EventDispatcher
import joyfill2.file.FileComponent
import joyfill2.tools.validation.ComponentValidity

internal class FileEditorImpl(
    override val component: FileComponent,
    identity: IdentityGenerator,
    document: Document,
    pages: PageCollection?,
    onChange: ((ChangeEvent) -> Unit)?,
    onValidate: (ComponentValidity) -> Unit,
    identifier: String,
    fieldId: String = component.id,
    dispatcher: EventDispatcher?,
) : AbstractFileEditorImpl<FileComponent>(
    component = component,
    identity = identity,
    document = document,
    pages = pages,
    onChange = onChange,
    onValidate = onValidate,
    fieldId = fieldId,
    identifier = identifier,
    dispatcher = dispatcher
), FileEditor
