package joyfill2.editors.file

import joyfill2.utils.Attachment

/**
 * Interface representing file operations that can be performed.
 */
interface FileOperations {

    /**
     * Adds a single attachment
     *
     * @param attachment The attachment to be added.
     */
    fun add(attachment: Attachment)

    /**
     * Adds a single URL
     *
     * @param url The URL to be added.
     */
    fun add(url: String)

    /**
     * Adds a list of attachments
     *
     * @param attachments The list of attachments to be added.
     */
    fun add(attachments: List<Attachment>)

    /**
     * Adds a list of URLs
     *
     * @param urls The list of URLs to be added.
     */
    fun add(urls: Collection<String>)

    /**
     * Sets the list of attachments, replacing any existing attachments.
     *
     * @param attachments The list of attachments to be set.
     */
    fun set(attachments: List<Attachment>)

    /**
     * Sets the list of URLs, replacing any existing URLs.
     *
     * @param urls The list of URLs to be set.
     */
    fun set(urls: Collection<String>)

    /**
     * Removes a single attachment
     *
     * @param attachment The attachment to be removed. Can be null.
     */
    fun remove(attachment: Attachment?)

    /**
     * Removes a single key
     *
     * @param key The key to be removed. Can be null.
     */
    fun remove(key: String?)

    /**
     * Removes a list of attachments
     *
     * @param attachments The list of attachments to be removed.
     */
    fun remove(attachments: List<Attachment>)

    /**
     * Removes a list of keys
     *
     * @param keys The list of keys to be removed.
     */
    fun remove(keys: Collection<String>)
}