package joyfill2.editors.document

import joyfill2.Document
import joyfill2.IdentityGenerator
import joyfill2.events.ChangeEvent
import joyfill2.parseDocument
import kotlinx.serialization.json.JsonObject
import wisdom.ResolutionResourceBuilder

/**
 * Creates a new [DocumentEditor] for the given [document].
 *
 * @param [document] the document to edit.
 * @param [identity] the identity generator to use while creating items in the document
 * @param [layout] the viewer to use during viewing and updating the document
 *
 * @return a new [DocumentEditor] for the given [document].
 */
fun editorOf(
    document: Document,
    identity: IdentityGenerator = IdentityGenerator.default,
    layout: LayoutConfig = LayoutConfig.convenientMobile(),
    functions: (ResolutionResourceBuilder.() -> Unit)? = null,
    onChange: ((ChangeEvent) -> Unit)? = null
): DocumentEditor = DocumentEditorImpl(document, identity, layout, functions, onChange)


/**
 * Creates a new [DocumentEditor] for the given [json].
 *
 * @param [json] the json representation of the document to edit.
 * @param [identity] the identity generator to use while creating items in the document
 * @param [layout] the viewer to use during viewing and updating the document
 *
 * @return a new [DocumentEditor] for the given [json].
 */
fun editorOf(
    json: JsonObject,
    identity: IdentityGenerator = IdentityGenerator.default,
    layout: LayoutConfig = LayoutConfig.convenientMobile(),
    functions: (ResolutionResourceBuilder.() -> Unit)? = null,
    onChange: ((ChangeEvent) -> Unit)? = null
): DocumentEditor {
    TODO()
}


/**
 * Creates a new [DocumentEditor] from the given [map].
 *
 * @param [map] the document to edit.
 * @param [identity] the identity generator to use while creating items in the document
 * @param [layout] the viewer to use during viewing and updating the document
 *
 * @return a new [DocumentEditor] for the given [map].
 */
fun editorOf(
    map: MutableMap<String, Any?>,
    identity: IdentityGenerator = IdentityGenerator.default,
    layout: LayoutConfig = LayoutConfig.convenientMobile(),
    functions: (ResolutionResourceBuilder.() -> Unit)? = null,
    onChange: ((ChangeEvent) -> Unit)? = null
): DocumentEditor {
    TODO()
}

/**
 * Creates a new [DocumentEditor] from the given [json].
 *
 * @param [json] the document to edit.
 * @param [identity] the identity generator to use while creating items in the document
 * @param [layout] the viewer to use during viewing and updating the document
 *
 * @return a new [DocumentEditor] for the given [json].
 */
fun editorOf(
    json: String,
    identity: IdentityGenerator = IdentityGenerator.default,
    layout: LayoutConfig = LayoutConfig.convenientMobile(),
    functions: (ResolutionResourceBuilder.() -> Unit)? = null,
    onChange: ((ChangeEvent) -> Unit)? = null
): DocumentEditor = editorOf(parseDocument(json), identity, layout, functions, onChange)