package joyfill2.editors.document

import joyfill2.Document
import joyfill2.Mappable
import joyfill2.Stage
import joyfill2.View
import joyfill2.collections.FieldCollection
import joyfill2.collections.PageCollection
import joyfill2.editors.event.EventCapture
import joyfill2.tools.validation.FieldsValidity

interface DocumentEditor : Mappable {
    var stage: Stage

    var name: String

    var id: String

    var identifier: String

    val fields: FieldCollection

    val views: List<View>

    val pages: PageCollection

    val capturedEvents: MutableList<EventCapture>

    fun set(key: String, value: Any?)

    fun <R> get(key: String): R

    fun integrity(): FieldsValidity

    fun resolveConditions()

    fun toDocument(): Document

    fun validate(): FieldsValidity
}