package joyfill2.editors.date.internal

import cinematic.mutableLiveOf
import joyfill2.Document
import joyfill2.collections.PageCollection
import joyfill2.date.DateComponent
import joyfill2.editors.components.internal.AbstractComponentEditor
import joyfill2.editors.date.DateEditor
import joyfill2.events.ChangeEvent
import joyfill2.events.EventDispatcher
import joyfill2.tools.validation.ComponentValidity
import joyfill2.tools.visibility.Visibility

internal class DateEditorImpl(
    override val component: DateComponent,
    override val format: String?,
    document: Document,
    pages: PageCollection?,
    onChange: ((ChangeEvent) -> Unit)?,
    onValidate: (ComponentValidity) -> Unit,
    identifier: String,
    fieldId: String = component.id,
    dispatcher: EventDispatcher?,
) : DateEditor,
    AbstractComponentEditor(
        document,
        pages = pages,
        component,
        onValidate,
        onChange,
        identifier,
        fieldId,
        dispatcher
    ) {

    override fun changeHiddenTo(value: Boolean) {
        hidden = value
        state.value = state.value.copy(
            visibility = if (value) Visibility.Hidden else Visibility.Visible,
        )
    }

    override val state by lazy {
        mutableLiveOf(
            DateEditorStateImpl(
                data = component.value,
                visibility = if (component.hidden) Visibility.Hidden else Visibility.Visible,
                validity = validate()
            )
        )
    }

    override fun customCondition(): Boolean {
        val value = component.value
        return value == null || value.toString().isEmpty() || value == 0L
    }

    override fun value(millis: Long?) {
        component.value = millis
        resolveConditions()
        state.value = state.value.copy(
            data = component.value,
            validity = validate(),
            visibility = if (component.hidden) Visibility.Hidden else Visibility.Visible,
        )
        notifyChange(millis)
    }
}