package joyfill2.editors.components.internal

import joyfill2.Document
import joyfill2.Field
import joyfill2.IdentityGenerator
import joyfill2.barcode.BarcodeField
import joyfill2.block.BlockField
import joyfill2.collection.CollectionField
import joyfill2.collections.PageCollection
import joyfill2.date.DateField
import joyfill2.dropdown.DropdownField
import joyfill2.editors.barcode.BarcodeEditorImpl
import joyfill2.editors.block.BlockEditorImpl
import joyfill2.editors.collection.internal.CollectionEditorImpl
import joyfill2.editors.components.ComponentEditor
import joyfill2.editors.date.internal.DateEditorImpl
import joyfill2.editors.dropdown.internal.DropdownEditorImpl
import joyfill2.editors.file.internal.FileEditorImpl
import joyfill2.editors.image.ImageEditorImpl
import joyfill2.editors.multi_select.internal.MultiSelectEditorImpl
import joyfill2.editors.number.internal.NumberEditorImpl
import joyfill2.editors.signature.SignatureEditorImpl
import joyfill2.editors.table.internal.TableEditorImpl
import joyfill2.editors.text.TextEditorImpl
import joyfill2.editors.text_area.TextAreaEditorImpl
import joyfill2.editors.unknown.UnknownEditor
import joyfill2.events.ChangeEvent
import joyfill2.events.EventDispatcher
import joyfill2.file.FileField
import joyfill2.image.ImageField
import joyfill2.multi_select.MultiSelectField
import joyfill2.number.NumberField
import joyfill2.signature.SignatureField
import joyfill2.table.TableField
import joyfill2.text.TextField
import joyfill2.text_area.TextAreaField
import wisdom.ResolutionResource
import wisdom.ast.Library

internal fun Field.toEditor(
    cache: MutableMap<String, ComponentEditor>,
    document: Document,
    pages: PageCollection,
    identity: IdentityGenerator,
    resolver: ResolutionResource,
    library: Library,
    onChange: ((ChangeEvent) -> Unit)?,
    dispatcher: EventDispatcher,
    dependents: () -> List<ComponentEditor>
): ComponentEditor = cache.getOrPut(id) {
    when (this) {
        is TextField -> TextEditorImpl(
            component = this,
            dependents = dependents(),
            resolver = resolver,
            library = library,
            document = document,
            onChange = onChange,
            onValidate = {},
            pages = pages,
            identifier = this.identifier,
            dispatcher = dispatcher
        )

        is BlockField -> BlockEditorImpl(
            component = this,
            dependents = dependents(),
            resolver = resolver,
            library = library,
            document = document,
            onChange = onChange,
            pages = pages,
            onValidate = {},
            identifier = this.identifier,
            dispatcher = dispatcher
        )

        is TextAreaField -> TextAreaEditorImpl(
            component = this,
            dependents = dependents(),
            resolver = resolver,
            library = library,
            document = document,
            onChange = onChange,
            onValidate = {},
            pages = pages,
            identifier = this.identifier,
            dispatcher = dispatcher
        )

        is TableField -> TableEditorImpl(
            component = this,
            identity = identity,
            document = document,
            pages = pages,
            onChange = onChange,
            identifier = this.identifier,
        )

        is BarcodeField -> BarcodeEditorImpl(
            component = this,
            dependents = dependents(),
            resolver = resolver,
            library = library,
            document = document,
            onChange = onChange,
            onValidate = {},
            pages = pages,
            identifier = this.identifier,
            dispatcher = dispatcher
        )

        is CollectionField -> CollectionEditorImpl(
            component = this,
            identity = identity,
            document = document,
            pages = pages,
            onChange = onChange,
            identifier = this.identifier,
        )

        is NumberField -> NumberEditorImpl(
            component = this,
            dependents = dependents(),
            resolver = resolver,
            library = library,
            pages = pages,
            document = document,
            onChange = onChange,
            onValidate = {},
            identifier = this.identifier,
            dispatcher = dispatcher
        )

        is DateField -> DateEditorImpl(
            component = this,
            format = this.format,
            document = document,
            onChange = onChange,
            pages = pages,
            onValidate = {},
            identifier = this.identifier,
            dispatcher = dispatcher
        )

        is DropdownField -> DropdownEditorImpl(
            component = this,
            options = this.options,
            document = document,
            onChange = onChange,
            pages = pages,
            onValidate = {},
            identifier = this.identifier,
            dispatcher = dispatcher
        )

        is SignatureField -> SignatureEditorImpl(
            component = this,
            dependents = dependents(),
            resolver = resolver,
            library = library,
            document = document,
            onChange = onChange,
            pages = pages,
            onValidate = {},
            identifier = this.identifier,
            dispatcher = dispatcher
        )

        is ImageField -> ImageEditorImpl(
            component = this,
            identity = identity,
            document = document,
            onChange = onChange,
            pages = pages,
            onValidate = {},
            identifier = this.identifier,
            dispatcher = dispatcher
        )

        is FileField -> FileEditorImpl(
            component = this,
            identity = identity,
            document = document,
            onChange = onChange,
            pages = pages,
            onValidate = {},
            identifier = this.identifier,
            dispatcher = dispatcher
        )

        is MultiSelectField -> MultiSelectEditorImpl(
            component = this,
            options = options,
            document = document,
            onChange = onChange,
            onValidate = {},
            pages = pages,
            identifier = this.identifier,
            dispatcher = dispatcher
        )

        else -> UnknownEditor(
            component = this,
            document = document,
            onChange = onChange,
            pages = pages,
            identifier = this.identifier,
            dispatcher = dispatcher
        )
    }
}