package joyfill2.editors.components.internal

import joyfill2.editors.barcode.BarcodeEditor
import joyfill2.editors.block.BlockEditor
import joyfill2.editors.components.ComponentEditorFinder
import joyfill2.editors.date.DateEditor
import joyfill2.editors.dropdown.DropdownEditor
import joyfill2.editors.file.FileEditor
import joyfill2.editors.image.ImageEditor
import joyfill2.editors.multi_select.MultiSelectEditor
import joyfill2.editors.number.NumberEditor
import joyfill2.editors.signature.SignatureEditor
import joyfill2.editors.text.TextEditor
import joyfill2.editors.text_area.TextAreaEditor

abstract class AbstractComponentEditorFinder : ComponentEditorFinder {
    override fun text(key: String?): TextEditor? = find(key) as? TextEditor
    override fun signature(key: String?): SignatureEditor? = find(key) as? SignatureEditor
    override fun block(key: String?): BlockEditor? = find(key) as? BlockEditor
    override fun textArea(key: String?): TextAreaEditor? = find(key) as? TextAreaEditor
    override fun number(key: String?): NumberEditor? = find(key) as? NumberEditor
    override fun dropdown(key: String?): DropdownEditor? = find(key) as? DropdownEditor
    override fun image(key: String?): ImageEditor? = find(key) as? ImageEditor
    override fun file(key: String?): FileEditor? = find(key) as? FileEditor
    override fun multiSelect(key: String?): MultiSelectEditor? = find(key) as? MultiSelectEditor
    override fun barcode(key: String?): BarcodeEditor? = find(key) as? BarcodeEditor
    override fun date(key: String?): DateEditor? = find(key) as? DateEditor
}