package joyfill2.editors.components.internal

import cinematic.mutableLiveOf
import joyfill2.Document
import joyfill2.collections.PageCollection
import joyfill2.components.internal.AbstractStringComponent
import joyfill2.editors.components.AbstractCompStringEditor
import joyfill2.editors.components.ComponentEditor
import joyfill2.events.ChangeEvent
import joyfill2.events.EventDispatcher
import joyfill2.tools.validation.ComponentValidity
import joyfill2.tools.visibility.Visibility
import wisdom.ResolutionResource
import wisdom.ast.Library

internal abstract class AbstractCompStringEditorImpl<T : AbstractStringComponent>(
    override val component: T,
    dependents: List<ComponentEditor>,
    resolver: ResolutionResource?,
    library: Library?,
    document: Document,
    pages: PageCollection?,
    onChange: ((ChangeEvent) -> Unit)?,
    onValidate: (ComponentValidity) -> Unit,
    identifier: String,
    fieldId: String,
    dispatcher: EventDispatcher?
) : AbstractComponentEditor(document, pages, component, onValidate, onChange, identifier, fieldId, dispatcher, dependents, resolver, library),
    AbstractCompStringEditor {

    override val state by lazy {
        mutableLiveOf(
            CompStringEditorStateImpl(
                data = component.value,
                visibility = if (component.hidden) Visibility.Hidden else Visibility.Visible,
                validity = validate(),
            )
        )
    }

    override fun changeHiddenTo(value: Boolean) {
        hidden = value
        state.value = state.value.copy(
            visibility = if (value) Visibility.Hidden else Visibility.Visible,
        )
    }

    override fun customCondition(): Boolean = component.value.isNullOrEmpty()

    override fun value(v: String?) {
        component.value = v
        resolveConditions()
        state.value = state.value.copy(
            data = v,
            validity = validate(),
            visibility = if (hidden) Visibility.Hidden else Visibility.Visible,
        )
        updateDependentsValues()
        notifyChange(v)
    }
}