package joyfill2.editors.components

import joyfill2.editors.barcode.BarcodeEditor
import joyfill2.editors.block.BlockEditor
import joyfill2.editors.date.DateEditor
import joyfill2.editors.dropdown.DropdownEditor
import joyfill2.editors.file.FileEditor
import joyfill2.editors.image.ImageEditor
import joyfill2.editors.multi_select.MultiSelectEditor
import joyfill2.editors.number.NumberEditor
import joyfill2.editors.signature.SignatureEditor
import joyfill2.editors.text.TextEditor
import joyfill2.editors.text_area.TextAreaEditor
import joyfill2.table.Finder

interface ComponentEditorFinder : Finder<ComponentEditor> {
    override fun text(key: String?): TextEditor?
    override fun block(key: String?): BlockEditor?
    override fun textArea(key: String?): TextAreaEditor?
    override fun barcode(key: String?): BarcodeEditor?
    override fun dropdown(key: String?): DropdownEditor?
    override fun number(key: String?): NumberEditor?
    override fun file(key: String?): FileEditor?
    override fun signature(key: String?): SignatureEditor?
    override fun multiSelect(key: String?): MultiSelectEditor?
    override fun date(key: String?): DateEditor?
    override fun image(key: String?): ImageEditor?
}