package joyfill2.editors.components

import joyfill2.components.Component
import joyfill2.schemas.Schema
import joyfill2.tools.validation.ValidateEditor
import joyfill2.tooltip.ToolTip

interface ComponentEditor : ValidateEditor, Schema {
    val component: Component

    var identifier: String
    val disabled: Boolean
    val tip: ToolTip?

    fun resolveConditions()
    fun updateDependentsValues()
    fun hide()
    fun show()
    fun changeHiddenTo(value: Boolean)
}