package joyfill2.editors.collection.internal

import joyfill2.Document
import joyfill2.IdentityGenerator
import joyfill2.collections.PageCollection
import joyfill2.editors.collection.CollectionEditor
import joyfill2.editors.collection.RowManager
import joyfill2.editors.collection.TableEditor
import joyfill2.editors.collection.Tables
import joyfill2.events.ChangeEvent
import joyfill2.table.TableSchema
import joyfill2.table.internal.TableComponentImpl

internal class TablesImpl(
    private val id: String,
    private val host: CollectionEditor,
    private val table: TableSchema,
    private val initialHiddenMap: Map<String, Boolean>,
    private val document: Document,
    private val pages: PageCollection,
    private val onChange: ((ChangeEvent) -> Unit)?,
    private val parent: RowManager,
    private val identity: IdentityGenerator,
    private val next: () -> RowManager?,
    private val prev: () -> RowManager?,
    private val onAppend: (tableId: String) -> Unit,
    private val resolveConditions: (id: String) -> Unit,
) : Tables {
    private val cache = mutableMapOf<String, TableEditor>()

    override fun find(key: String?): TableEditor? = host.component.schema.table(key)?.let { tableSchema ->
        getOrCreateTableEditor(tableSchema)
    }

    override fun all(): List<TableEditor> = host.component.schema.all().filter {
        it.id in table.children || it.title in table.children
    }.mapNotNull { tableSchema ->
        getOrCreateTableEditor(tableSchema)
    }

    private fun getOrCreateTableEditor(schema: TableSchema): TableEditor? {
        cache[schema.id]?.let { return it }

        val container = parent.row.children.find(schema.id) ?: return null

        val child = TableComponentImpl(
            container = container,
            schema = schema
        )

        val editor = NestableTableEditor(
            id = "${this.id}:${child.id}",
            host = host,
            document = document,
            pages = pages,
            onChange = onChange,
            parent = parent,
            initialHiddenMap = initialHiddenMap,
            component = child,
            identity = identity,
            next = next,
            prev =  prev,
            onAppend = onAppend,
            resolveConditions = resolveConditions
        )

        cache[schema.id] = editor

        return editor
    }
}