package joyfill2.editors.collection.internal

import joyfill2.editors.collection.entries.LazyEntry
import joyfill2.editors.collection.entries.RowEntry
import joyfill2.editors.collection.entries.TableEntry

internal fun TableEntry.expanded(): List<LazyEntry> = buildList {
    add(this@expanded.copy(expanded = true))
    table.rows.all().forEachIndexed { idx, rowManager ->
        add(
            RowEntry(
                level = level,
                manager = rowManager,
                expanded = false,
                hidden = table.state.value.hidden,
                table = table,
                number = idx + 1,
            )
        )
    }
}