package joyfill2.editors.collection.internal

import joyfill2.Document
import joyfill2.IdentityGenerator
import joyfill2.collections.PageCollection
import joyfill2.editors.collection.CollectionEditor
import joyfill2.editors.collection.RowManager
import joyfill2.editors.collection.Tables
import joyfill2.editors.table.internal.AbstractRowManager
import joyfill2.events.ChangeEvent
import joyfill2.table.Column
import joyfill2.table.Row
import joyfill2.table.TableSchema
import joyfill2.tools.validation.RowValidity

internal class RowManagerImpl(
    override val id: String,
    document: Document,
    pages: PageCollection,
    private val host: CollectionEditor,
    private val table: TableSchema,
    private val initialHiddenMap: Map<String, Boolean>,
    override val row: Row,
    columns: List<Column>,
    identity: IdentityGenerator,
    onRowChange: ((ChangeEvent) -> Unit)?,
    onChange: ((ChangeEvent) -> Unit)?,
    onValidate: (RowValidity) -> Unit,
    override val next: () -> RowManager?,
    override val prev: () -> RowManager?,
    private val onAppend: (tableId: String) -> Unit,
    private val resolveConditions: (id: String) -> Unit,
) : AbstractRowManager(row, document, columns, identity, onRowChange, onValidate, host.id, host.identifier), RowManager {
    override val tables: Tables by lazy {
        TablesImpl(
            id = id,
            host = host,
            identity = identity,
            initialHiddenMap = initialHiddenMap,
            parent = this,
            table = table,
            next = next,
            prev = prev,
            document = document,
            pages = pages,
            onAppend = onAppend,
            onChange = onChange,
            resolveConditions = resolveConditions,
        )
    }

}