package joyfill2.editors.collection.internal

import joyfill2.editors.collection.entries.LazyEntry
import joyfill2.editors.collection.entries.TableEntry

internal fun CollectionEditorImpl.updateEntries(
    entry: LazyEntry,
    entriesToAdd: List<LazyEntry>,
) {
    val list = state.value.entries.toMutableList()
    val index = list.indexOf(entry)

    list.remove(entry)
    list.add(index, entry.copy(expanded = true))

    list.addAll(index + 1, entriesToAdd)

    state.value = state.value.copy(entries = list)

    val childTableEntries = entriesToAdd.filterIsInstance<TableEntry>()
    if (childTableEntries.isNotEmpty()) {
        val allExpandedChildren = mutableListOf<LazyEntry>()
        val childIndices = mutableListOf<Int>()

        childTableEntries.forEach { tableEntry ->
            val childIndex = state.value.entries.indexOf(tableEntry)
            if (childIndex >= 0) {
                childIndices.add(childIndex)
                allExpandedChildren.addAll(tableEntry.expanded())
            }
        }

        if (allExpandedChildren.isNotEmpty()) {
            val updatedList = state.value.entries.toMutableList()
            childTableEntries.forEach { tableEntry ->
                updatedList.removeAll { it.id.contains(tableEntry.id) }
            }

            if (childIndices.isNotEmpty()) {
                val firstChildIndex = childIndices.minOrNull() ?: (index + 1)
                updatedList.addAll(firstChildIndex, allExpandedChildren)
            }

            state.value = state.value.copy(entries = updatedList)
        }
    }
}