package joyfill2.editors.collection.internal

import joyfill2.editors.collection.entries.LazyEntry
import joyfill2.editors.collection.entries.RowEntry
import joyfill2.editors.collection.entries.TableEntry

internal fun CollectionEditorImpl.expand(rowEntry: RowEntry) {
    val entriesToAdd = mutableListOf<LazyEntry>()

    rowEntry.manager.tables.all().forEach { table ->
        entriesToAdd.add(
            TableEntry(
                level = rowEntry.level + 1,
                table = table,
                expanded = true,
                hidden = table.state.value.hidden,
                parent = rowEntry.manager.row
            )
        )
    }
    updateEntries(rowEntry, entriesToAdd)
}

internal fun CollectionEditorImpl.collapse(entry: LazyEntry) {
    val list = state.value.entries.toMutableList()
    val index = list.indexOf(entry)
    if (index >= 0) {
        list.removeAll { it.id.contains(entry.id) }
        list.add(index.coerceAtMost(list.size), entry.copy(expanded = false))
        state.value = state.value.copy(entries = list)
    }
}

internal fun CollectionEditorImpl.expand(tableEntry: TableEntry) {
    val expandedEntries = tableEntry.expanded()

    val list = state.value.entries.toMutableList()
    val index = list.indexOf(tableEntry).takeIf { it >= 0 } ?: list.size

    list.removeAll { it.id.contains(tableEntry.id) }
    list.addAll(index, expandedEntries)
    state.value = state.value.copy(entries = list)
}