package joyfill2.editors.collection.entries

import joyfill2.editors.collection.TableEditor
import joyfill2.table.Row

data class TableEntry(
    override val level: Int,
    override val table: TableEditor,
    override val expanded: Boolean,
    override val hidden: Boolean,
    val parent: Row? = null,
) : LazyEntry {
    override val id by lazy { table.id }

    override val isValid: Boolean get() = !table.component.required || table.rows.all().isNotEmpty()

    override fun copy(expanded: Boolean) = TableEntry(level, table, expanded, hidden, parent)
}