package joyfill2.editors.collection.entries

import joyfill2.editors.collection.RowManager
import joyfill2.editors.collection.TableEditor
import joyfill2.tools.validation.Valid

data class RowEntry(
    override val level: Int,
    override val table: TableEditor,
    override val expanded: Boolean,
    override val hidden: Boolean,
    val number: Int,
    val manager: RowManager,
) : LazyEntry {
    override val id: String by lazy { manager.id }

    override val isValid: Boolean get() = isValidInternal(manager)

    private fun isValidInternal(manager: RowManager): Boolean {
        var allCellsValid = true
        manager.all().forEach { cell ->
            val validity = cell.state.value.validity
            if (validity !is Valid) {
                allCellsValid = false
            }
        }

        if (!allCellsValid) {
            return false
        }

        val childTables = manager.tables.all()
        for (table in childTables) {
            val tableRows = table.rows.all()
            if (table.required && tableRows.isEmpty()) {
                return false
            }

            if (tableRows.isEmpty()) {
                continue
            }

            for (childRow in tableRows) {
                val childValid = isValidInternal(childRow)
                if (!childValid) {
                    return false
                }
            }
        }
        return true
    }
    override fun copy(expanded: Boolean) = RowEntry(level, table, expanded, hidden, number, manager)
}