package joyfill2.editors.collection

import cinematic.Live
import joyfill2.collection.CollectionComponent
import joyfill2.editors.collection.entries.LazyEntry
import joyfill2.editors.collection.entries.RowEntry
import joyfill2.editors.collection.entries.TableEntry
import joyfill2.editors.components.ComponentEditor
import joyfill2.editors.table.Selection
import joyfill2.editors.utils.Selector

interface CollectionEditor : ComponentEditor, Selector<RowEntry> {
    override val component: CollectionComponent
    override val state: Live<CollectionEditorState>
    fun root(): TableEditor
    fun toggle(entry: LazyEntry)
    fun edit()
    fun selectAll(entry: TableEntry)
    fun selection(entry: TableEntry): Selection
    fun addAfter()
    fun moveUp()
    fun submit()
    fun moveDown()
    fun addFormAfter()
    fun delete()
    fun close()
}