package joyfill.table

import joyfill.fields.table.BarcodeColumn
import joyfill.fields.table.Column
import joyfill.fields.table.DropdownColumn
import joyfill.fields.table.MultiselectColumn
import joyfill.fields.table.NumberColumn
import joyfill.fields.table.TextColumn
import joyfill.utils.Option2

sealed interface ColumnFilter {
    val column: Column
    val sort: SortingOption
    val value: Any?

    data class TextColumnFilter(
        override val column: TextColumn,
        override val sort: SortingOption,
        override val value: String?
    ) : ColumnFilter

    data class NumberColumnFilter(
        override val column: NumberColumn,
        override val sort: SortingOption,
        override val value: String?
    ) : ColumnFilter

    data class DropdownColumnFilter(
        override val column: DropdownColumn,
        override val sort: SortingOption,
        override val value: Option2?
    ) : ColumnFilter

    data class MultiselectColumnFilter(
        override val column: MultiselectColumn,
        override val sort: SortingOption,
        override val value: Option2?
    ) : ColumnFilter

    data class BarcodeColumnFilter(
        override val column: BarcodeColumn,
        override val sort: SortingOption,
        override val value: String?
    ) : ColumnFilter

    fun sorted(option: SortingOption?): ColumnFilter = when (this) {
        is DropdownColumnFilter -> copy(sort = option ?: SortingOption.None)
        is MultiselectColumnFilter -> copy(sort = option ?: SortingOption.None)
        is TextColumnFilter -> copy(sort = option ?: SortingOption.None)
        is NumberColumnFilter -> copy(sort = option ?: SortingOption.None)
        is BarcodeColumnFilter -> copy(sort = option ?: SortingOption.None)
    }

    fun copy(key: String?): ColumnFilter = when (this) {
        is DropdownColumnFilter -> this
        is MultiselectColumnFilter -> this
        is TextColumnFilter -> copy(value= key)
        is NumberColumnFilter -> copy(value= key)
        is BarcodeColumnFilter -> copy(value= key)
    }
}