package joyfill.editors.internal

import joyfill.ChangeEvent
import joyfill.Document
import joyfill.EventDispatcher
import joyfill.IdentityGenerator
import joyfill.chart.LineCollection
import joyfill.chart.internal.LineCollectionImpl
import joyfill.collections.PageCollection
import joyfill.editors.AxesEditor
import joyfill.editors.ChartFieldEditor
import joyfill.fields.ChartField
import joyfill.validation.FieldInvalid
import joyfill.validation.FieldValid
import joyfill.validation.FieldValidity

@PublishedApi
internal class ChartFieldEditorImpl(
    document: Document,
    field: ChartField,
    identity: IdentityGenerator,
    pages: PageCollection,
    dispatcher: EventDispatcher,
    onChange: ((ChangeEvent) -> Unit)?
) : AnyFieldEditor<ChartField>(document, field, pages, dispatcher, onChange), ChartFieldEditor {
    override val lines: LineCollection = LineCollectionImpl(document, identity, field, onChange)

    override val axes by lazy { AxesEditorImpl() }

    inner class AxesEditorImpl : AxesEditor {
        override val x by lazy { AxisEditorImpl(field.x) }
        override val y by lazy { AxisEditorImpl(field.y) }
    }

    override fun validate(): FieldValidity {
        if (hidden.value || !field.required) return FieldValid(field, emptyList())
        val points = lines.all().flatMap { it.points() }
        if (field.required && points.isEmpty()) return FieldInvalid(field, listOf("Field ${field.title} is required"))
        return FieldValid(field, emptyList())
    }

}