package joyfill.table.internal.tools

import joyfill.table.ColumnFilter
import joyfill.table.RowEditor
import joyfill.table.SortingOption

internal fun Collection<RowEditor>.thatMatch(filter: ColumnFilter) = when (filter) {
    is ColumnFilter.DropdownColumnFilter -> thatMatch(filter)
    is ColumnFilter.TextColumnFilter -> thatMatch(filter)
}

internal fun ColumnFilter.TextColumnFilter.toFunction() = { editor: RowEditor ->
    editor.text(column.id)?.text?.value
}

internal fun Collection<RowEditor>.thatMatch(predicate: ColumnFilter.TextColumnFilter): List<RowEditor> {
    val filtered = filter {
        if (predicate.value == null) return@filter true
        it.text(predicate.column.id)?.text?.value?.contains(predicate.value, ignoreCase = true) == true
    }
    return when (predicate.sort) {
        SortingOption.None -> filtered
        SortingOption.Ascending -> filtered.sortedBy(predicate.toFunction())
        SortingOption.Descending -> filtered.sortedByDescending(predicate.toFunction())
    }
}

internal fun ColumnFilter.DropdownColumnFilter.toFunction() = { editor: RowEditor ->
    editor.dropdown(column.id)?.selected()?.value
}

internal fun Collection<RowEditor>.thatMatch(predicate: ColumnFilter.DropdownColumnFilter): List<RowEditor> {
    val filtered = filter {
        if (predicate.value == null) return@filter true
        it.dropdown(predicate.column.id)?.selected()?.id == predicate.value.id
    }
    return when (predicate.sort) {
        SortingOption.None -> filtered
        SortingOption.Ascending -> filtered.sortedBy(predicate.toFunction())
        SortingOption.Descending -> filtered.sortedByDescending(predicate.toFunction())
    }
}